/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIFSPMessageConstants;
import com.ibm.hsc.common.util.PropertiesLoader;
import java.math.BigInteger;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class PIBuildCommandPacket {
    private static Properties m_configValuesPropObj = null;

    public static Vector getDefaultCommandPacket() {
        return PIBuildCommandPacket.getDefaultCommandPacket(null);
    }

    public static Vector getDefaultCommandPacket(byte[] byArray) {
        Vector<Byte> vector = new Vector<Byte>(40);
        for (int i = 0; i < PIFSPMessageConstants.DEFAULT_MESSAGE.length; ++i) {
            if (byArray != null && i > 7 && i < 12) {
                vector.addElement(new Byte(byArray[i - 8]));
                continue;
            }
            vector.addElement(new Byte(PIFSPMessageConstants.DEFAULT_MESSAGE[i]));
        }
        return vector;
    }

    public static byte[] buildCommand(String string, String[] stringArray) throws Exception {
        return PIBuildCommandPacket.buildCommand(string, stringArray, null);
    }

    public static byte[] buildCommand(String string, String[] stringArray, byte[] byArray) throws Exception {
        int n;
        int n2;
        Vector vector = null;
        byte[] byArray2 = null;
        String string2 = null;
        if (string == null || string.equals("")) {
            throw new Exception(" CommandName can not be null");
        }
        string2 = (String)m_configValuesPropObj.get(string);
        if (string2 == null) {
            String string3 = " Invalid CommandName : " + string;
            throw new Exception(string3);
        }
        vector = PIBuildCommandPacket.getDefaultCommandPacket(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 0) {
            byte by;
            String string4;
            int n3;
            for (n3 = 0; n3 < 2; ++n3) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                by = (byte)Integer.valueOf(string4, 16).intValue();
                vector.set(12 + n3, new Byte(by));
            }
            for (n3 = 0; n3 < 2; ++n3) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                by = (byte)Integer.valueOf(string4, 16).intValue();
                vector.set(20 + n3, new Byte(by));
            }
            String string5 = stringTokenizer.nextToken().trim();
            n2 = Integer.valueOf(string5, 16);
            vector.set(14, new Byte((byte)n2));
            if (stringArray != null) {
                String string6 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6, "+");
                int n4 = stringTokenizer2.countTokens();
                int n5 = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    String string7;
                    String string8 = stringTokenizer2.nextToken();
                    if ((string8 = string8.trim().toUpperCase()).startsWith("PAD")) {
                        string7 = string8.substring(3);
                        int n6 = 1;
                        if (string7.length() > 0) {
                            n6 = Integer.parseInt(string7);
                        }
                        for (int i = 0; i < n6; ++i) {
                            vector.addElement(new Byte(0));
                        }
                        continue;
                    }
                    String string9 = string7 = stringArray[n5++];
                    string7 = string7.trim();
                    if (string8.equals("BYTE")) {
                        byte by2 = (byte)Integer.valueOf(string7, 10).intValue();
                        vector.addElement(new Byte(by2));
                        continue;
                    }
                    if (string8.equals("CHAR") || string8.equals("DATA")) {
                        byte[] byArray3 = null;
                        byArray3 = string8.equals("DATA") ? ByteUtilities.hexStringToByteArray(string7) : string7.getBytes();
                        for (int i = 0; i < byArray3.length; ++i) {
                            vector.addElement(new Byte(byArray3[i]));
                        }
                        if (!string8.equals("CHAR")) continue;
                        vector.addElement(new Byte(0));
                        continue;
                    }
                    if (string8.equals("SHORT")) {
                        int n7 = Integer.parseInt(string7);
                        for (int i = 0; i < 2; ++i) {
                            vector.addElement(new Byte((byte)(n7 >> (1 - i) * 8 & 0xFF)));
                        }
                        continue;
                    }
                    if (string8.equals("INT")) {
                        long l = Long.parseLong(string7);
                        for (int i = 0; i < 4; ++i) {
                            vector.addElement(new Byte((byte)(l >> (3 - i) * 8 & 0xFFL)));
                        }
                        continue;
                    }
                    if (string8.equals("LONG")) {
                        BigInteger bigInteger = new BigInteger(string7);
                        long l = bigInteger.longValue();
                        for (int i = 0; i < 8; ++i) {
                            vector.addElement(new Byte((byte)(l >> (7 - i) * 8 & 0xFFL)));
                        }
                        continue;
                    }
                    throw new Exception("Unsupported parameter type: " + string8 + ", in command string: " + string + " = " + string2);
                }
            }
        } else {
            throw new Exception(stringArray.length + " parameters were specified, but no parameters were " + "found in command string: " + string + " = " + string2);
        }
        int n8 = 0;
        while (vector.size() < 40) {
            n8 = (byte)(n8 + 1);
            vector.addElement(new Byte(0));
        }
        n2 = vector.size();
        byArray2 = new byte[n2];
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = (Byte)vector.elementAt(n);
        }
        for (n = 0; n < 4; ++n) {
            byArray2[n + 4] = (byte)(n2 >> (3 - n) * 8 & 0xFF);
        }
        byArray2[15] = n8;
        return byArray2;
    }

    static {
        try {
            m_configValuesPropObj = PropertiesLoader.openPropFile("/opt/hsc/data/PIHSCCommandPropFile");
        }
        catch (Exception exception) {
            System.out.println(">>>>>>>>>>>>>>>>>> Error opening /opt/hsc/data/PIHSCCommandPropFile");
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._HSCClassLogInfo);
        }
    }
}

